<?php
include APPLICATION_PATH . '/DAO/UtilisateurDAO.php';
include APPLICATION_PATH . '/DAO/AuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/RoleDAO.php';
include APPLICATION_PATH . '/DAO/RoleAuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/LaboDAO.php';
include APPLICATION_PATH . '/DAO/UserLaboDAO.php';
include APPLICATION_PATH . '/DAO/UserSiteDAO.php';
include APPLICATION_PATH . '/DAO/SiteDAO.php';
include APPLICATION_PATH . '/DAO/LogDAO.php';
include PUBLIC_PATH.'/Fonctions/Fonction.php';
#include PUBLIC_PATH . '/files_to_include/Constantes.php';

class ModuleUser
{
    protected $user;
     
    public function connect(){
        
         $login = isset($_POST["login"])?  $_POST["login"] : null;
       $password = isset($_POST['password'])? sha1(md5($_POST["password"])) : null;
       $userDao = new UtilisateurDAO();
       $roleAuthDao = new RoleAuthorisationDAO();
       $user =  $userDao->getUtilisateurLoginPassword($login, $password);
       if ( is_object($user)){
           session_cache_limiter('private_no_expire');
           session_cache_expire(60);
           session_start();
           $_SESSION["codeUser"] = $user->getCode();
           $_SESSION["nameUser"] = $user->getName();
            //Module d'enregistrement des logs 
            try {
                $f = new Fonction();
               
                $descr = "Connexion de l'utilisateur " . $user->getName() . ", dont le login est " . $user->getLogin() . "";
                
                $f->EnregistrerLog($descr, $user);
                
            } catch (Exception $exc) {
                  $response = array('type' => "error", 'msg' => $exc->getMessage(),"result"=>array());
                 echo json_encode($response);
                 exit();
            }
            $authDao = new AuthorisationDAO();
            $listeParent = $authDao->listAuthParent();
            $list=$roleAuthDao->listRoleAuthorisationByRole($user->getRole());
            
                 $object = new stdClass();
                $object->name = $user->getName();
                $object->login = $user->getLogin();
                $object->password = $user->getLogin();
               // $object->birthday = $user->getBirthday();
                 $object->phone= $user->getPhone();
                 //$object->cni= $user->getCni();
                 $object->sexe= $user->getSexe();
                 $roleAuthDao = new RoleAuthorisationDAO();
                 $listRoleAuth = $roleAuthDao->getRoleAuthorisationByRole($user->getRole());
                 $listAuth = array();
                 foreach ($list as $roleAuth){
                   $auth = new stdClass();
                   $auth->label = $roleAuth->getAuthorisation()->getLabel();
                   $auth->code = $roleAuth->getAuthorisation()->getCode();
                   $listAuth[] = $auth;
                 }
                 $object->role= array('code'=>$user->getRole()->getCode(),'label'=>$user->getRole()->getLabel(),'authorisation'=>$listAuth);
            
           echo json_encode(array("type" => "success",'msg' => "User registration success","result"=>$object));
            exit();
       }else{
           
           echo json_encode(array("type" => "error","result"=>array()));
       }
       exit();
    }
   
    public function adduser()
    {
       
        // action body
        if (!empty($_POST)) {
           
            $name = trim($_POST['name']);
            $sexe = trim($_POST['sexe']);
            $login = trim($_POST['login']);
            $role = trim($_POST['role'],'"');
            $listSite = $_POST['listSite'];
            $listLabo = $_POST['listLabo'];
            $password = sha1(md5($_POST['login']));
            $cni = trim($_POST['cni']);
            $birthday = new \DateTime(trim($_POST['birthdate']));
            $phone = trim($_POST['phone']);
            $userDao = new UtilisateurDAO();
            $userDao->_em->beginTransaction();
            try {
                
                $userDao = new UtilisateurDAO();
                $userExistant = $userDao->getUtilisateurByLogin($login);
                
            if(!is_null($userExistant) && !empty($userExistant))
                    {

                        $response = array('type' => "error", 'msg' => "This login is already assigned. Please choose another");
                        echo json_encode($response);
                        exit();
                    }
                    
                    $roleDao = new RoleDAO();
                    $role = $roleDao->getRoleByCode($role);
                   
               if(is_object($role)){
                   //Save User
                     
                    $user = new \Application\Models\Utilisateur();
                    $user->setBirthday($birthday);
                    $user->setCni($cni);
                    $user->setName($name);
                    $user->setPassword($password);
                    $user->setPhone($phone);
                    $user->setLogin($login);
                    $user->setSexe($sexe);
                    $user->setRole($role);
                    $user->setState(1);
                    $user->setDatecreation(new \DateTime());
                    $user->setCode(str_replace(' ', '', microtime()));
                    $userDao->save($user);
                    // Attribuate labos to  user if exist
                    $userLaboDao = new UserLaboDAO();
                    foreach($listLabo as $elemLabo){
                        $laboDao = new LaboDAO();
                        $labo = $laboDao->getLaboByCode($elemLabo['value']);
                        if(is_object($labo)){
                            $userLabo = new Application\Models\LaboratoireUtilisateur();
                            $userLabo->setCode(str_replace(' ', '', microtime()));
                            $userLabo->setDateaffectation(new \DateTime());
                            $userLabo->setLaboratoire($labo);
                            $userLabo->setUtilisateur($user);
                            $userLabo->setState(1);
                        }
                        
                    }
                     // Attribuate sites to  user if exist
                    foreach($listSite as $elemSite){
                        $siteDao = new SiteDAO();
                        $site = $siteDao->getSiteByCode($elemSite['value']);
                        if(is_object($site)){
                            $userSite = new Application\Models\SiteUtilisateur();
                            $userSite->setCode(str_replace(' ', '', microtime()));
                            $userSite->setDateaffectation(new \DateTime());
                            $userSite->setSite($site);
                            $userSite->setUtilisateur($user);
                            $userSite->setState(1);
                        }
                        
                    }
                    
                    
                
                }
               
                $f = new Fonction();
                $utilisateurDao = new UtilisateurDAO();
                $userAdmin = $utilisateurDao->getUtilisateurByCode($_SESSION["codeUser"]);
                $descr = "Saving of user : " . $name . ", with login : " . $login . " ";
                $descr .= "by user " . $userAdmin->getName() ;
                $f->EnregistrerLog($descr, $userAdmin);
                
                $object = new stdClass();
                $object->name = $user->getName();
                $object->login = $user->getLogin();
                $object->password = $user->getLogin();
                $object->birthday = $user->getBirthday();
                 $object->phone= $user->getPhone();
                 $object->cni= $user->getCni();
                 $object->sexe= $user->getSexe();
                 $roleAuthDao = new RoleAuthorisationDAO();
                 $listRoleAuth = $roleAuthDao->getRoleAuthorisationByRole($role);
                 $listAuth = array();
                 foreach ($listRoleAuth as $roleAuth){
                   $auth = new stdClass();
                   $auth->label = $roleAuth->getAuthorisation()->getLabel();
                   $auth->code = $roleAuth->getAuthorisation()->getCode();
                   $listAuth[] = $auth;
                 }
                
                 $object->role= array('code'=>$user->getRole()->getCode(),'label'=>$user->getRole()->getLabel(),'authorisation'=>$listAuth);
                 
                $response = array('type' => "success", 'msg' => " User has been registered successfully ",'data'=>$object);
                $userDao->_em->commit();
                 echo json_encode($response);
                 exit();
                 
            } catch (Exception $exc) {
               $userDao->_em->rollBack();
                $response = array('type' => "error", 'msg' => $exc->getMessage());
                 echo json_encode($response);
                 exit();
            }
           
        } 
    }
    public function sayHello(){
        echo json_encode("Bonjour");
        exit();
    }
    public function authUser(){
        $codeUser = trim($_POST["codeUser"]);

        $authDao = new AuthorisationDAO();
        $roleAuthDao=new RoleAuthorisationDAO();
         
        $userDao = new UtilisateurDAO(); 
        $user=$userDao->getUtilisateurByCode($codeUser);
       
        
        
            $result = [];
           $list=$roleAuthDao->listRoleAuthorisationByRole($user->getRole());
            $result = [];
            foreach($list as $elem){
                $auth = $elem->getAuthorisation();
                if(is_object($auth->getParent())){
                    $result[] = array("code"=>$auth->getCode(),"label"=>$auth->getLabel(),"action"=>$auth->getAction(),"parent"=>$auth->getParent()->getLabel());
                }else{
                    $result[] = array("code"=>$auth->getCode(),"label"=>$auth->getLabel(),"action"=>$auth->getAction());
                }
                
            }
         
        echo json_encode(array("type" => "success",'msg' => "Connexion reussie","result"=>$result));
        exit;
    }

    public function editerAction()
    {
        
        $utilisateurDao = new UtilisateurDAO();
        $profilDao = new ProfilDAO();

        if (!empty($_POST["data"])) {

             $error = 0;
            $data = $_POST['data'];
             $data = json_decode($data);
            $nom = trim($data->nom);
            $nomJeune = trim($data->nomJeune);
            $prenom = trim($data->prenom);
            $sexe = trim($data->sexe);
            $login = trim($data->login);
            $profils = $data->profil;
            $password = sha1(md5($data->password));
            $carte = trim($data->cni);
            $date = new \DateTime($data->date);
            $telephone = trim($data->telephone);
            $nationalite = trim($data->nationalite);
            $lieu = trim($data->lieu);
            $DateLivCni = new \DateTime($data->delivrerCni);
            $lieuLivCni = trim($data->delivrerLieu);
            $idUser = (int)$data->user;
            

            try {
                $utilisateurDao->_em->beginTransaction();
                    $utilisateur = $utilisateurDao->getUtilisateurById($idUser);
                    if(is_object($utilisateur)){
                          $profilDao = new ProfilDAO();
                          $profil = $profilDao->getProfil((int)$profils);
                       if(is_object($profil)){
                            if($nom!=null && $nom!=""){
                                    $utilisateur->getIdpersonne()->setNom($nom);
                                  }
                                   if($nomJeune!=null && $nomJeune!=""){
                                    $utilisateur->getIdpersonne()->setNomJeunefille($nomJeune);
                                  }
                                if($prenom!=null && $prenom!=""){
                                    $utilisateur->getIdpersonne()->setPrenom($prenom);
                                }
                                if($sexe!=null && $sexe!=""){
                                    $utilisateur->getIdpersonne()->setSexe($sexe);
                                }
                                if($carte!=null && $carte!=""){
                                    $utilisateur->getIdpersonne()->setNumcarte($carte);
                                }
                                if($telephone!=null && $telephone!=""){
                                    $utilisateur->getIdpersonne()->setTelephone($telephone);
                                }
                                if($nationalite!=null && $nationalite!=""){
                                    $utilisateur->getIdpersonne()->setNationalite($nationalite);
                                }
                                if($lieu!=null && $lieu!=""){
                                    $utilisateur->getIdpersonne()->setLieunaissance($lieu);
                                }
                                 if($lieuLivCni!=null && $lieuLivCni!=""){
                                    $utilisateur->getIdpersonne()->setLieudelivrancecni($lieuLivCni);
                                }
                                 if($DateLivCni!=null && $DateLivCni!=""){
                                    $utilisateur->getIdpersonne()->setDatedelivrancecni($DateLivCni);
                                }
                                if($nationalite!=null && $nationalite!=""){
                                    $utilisateur->getIdpersonne()->setNationalite($nationalite);
                                }
                                if(is_object($date)){
                                    $utilisateur->getIdpersonne()->setDatenaissance($date);
                                }
                                if($login!=null && $login!=""){
                                    $utilisateur->setLogin($login);
                                }
//                                if($password!=null && $password!=""){
//                                    $utilisateur->setPassword($password);
//                                }
                                $utilisateur->setIdprofil($profil);
                               
                       }
                                
                       
                       $personneDao = new PersonneDAO();
                                $personneDao->modifier($utilisateur->getIdpersonne());
                                $utilisateurDao->modifier($utilisateur);
                                 $utilisateurDao->_em->commit();
                                $rep = array('msg' => 1,'msg1'=>"Modification effectuer avec success");
                    }else{
                        $utilisateurDao-> _em->rollBack();
                        $error = 1;
                    //$this->view->errormsg=$e->getMessage();
                    $errormsg = "Utilisateur incorrect"; //"Echec d'enregistrement";
                    $rep = array('msg' => $error, 'msg1' => $errormsg);
                    echo json_encode($rep);
                    exit();
                    }
                    
                    
                 
            }catch (Exception $exc) {
               $utilisateurDao->_em->rollBack();
                $error = 1;
                $errormsg = $exc->getMessage() ; //"Echec d'enregistrement";
               
            }
            if ($error == 1) {
                $rep = array('msg' => $error, 'msg1' => $errormsg);
            } else {
                
                try {
                $f = new Fonction();
               
                $descr = "Enregistrement de l'utilisateur " . $nom . ", dont le login est " . $login . "";
                
                $user = $this->user;
                $f->EnregistrerLog($descr, $user);
                
            } catch (Exception $exc) {

            }
                $rep = array('msg' => $error, 'msg1' => "enregistrement effectué avec succes");
                
            }
            echo json_encode($rep);
            exit();
        }else{
            $id = $this->getRequest()->getParam('id');
        $objuti = new UtilisateurDAO();
        $utilisateur = $objuti->getUtilisateurById($id);
        $profilDAO = new ProfilDAO();
        $profils = $profilDAO->lister();
        $this->view->profils = $profils;
        $this->view->utilisateur = $utilisateur;
            
        }
        
        
    }
      public function listUser()
    {
       $table = 'utilisateurs';

        $primaryKey = 'code';
        $columns = array(
            array('db' => 'code', 'dt' => 0),
            array('db' => 'login', 'dt' => 1),
            array('db' => 'name' , 'dt' => 2),
            array('db' => 'sexe' , 'dt' => 3),
             array('db' => 'cni' , 'dt' => 4),
             array('db' => 'role' , 'dt' => 5)
        );

        $sql_details = array(
            'user' => DB_USER,
            'pass' => DB_PASSWORD,
            'db' => DB_NAME,
            'host' => HOSTNAME
        );

         
        require(PUBLIC_PATH . '/files_to_include/ssp.class.php');

        $resultatDataTable = SSP::simple($_POST, $sql_details, $table, $primaryKey, $columns);
        
       
        echo json_encode($resultatDataTable);
        exit();
    }
    public function consulterAction()
    {
        $id = $this->getRequest()->getParam('id');
        $objuti = new UtilisateurDAO();
        $utilisateur = $objuti->getUtilisateurById($id);
        $profilDAO = new ProfilDAO();
        $profils = $profilDAO->lister();
        $this->view->profils = $profils;

        $this->view->utilisateur = $utilisateur;
         
    }

    public function supprimerAction()
    {
        if (!is_null($this->getRequest()->getParam('idUser'))) {

            $id = $this->getRequest()->getParam('idUser');
            
            try {
                $user = new UtilisateurDAO();
                $utilisateur = $user->getUtilisateurById($id);
                if (empty($utilisateur)) {
                    $rep = array('msg' => "Impossible de trouver l'utilisateur");
                } else {
                    try {
                        $utilisateur->setStatut(0);
                        $user->modifier($utilisateur);
                        $rep = array("type"=>"success",'msg1' => "Suppression effectue avec success");
                        try {
                            $f = new Fonction();

                            $descr = "Suppression de l'utilisateur " . $utilisateur->getIdpersonne()->getNom() . ", dont le login est " . $utilisateur->getLogin() . "";
                            
                            //$user = $this->user;
                            $f->EnregistrerLog($descr, $utilisateur);

                        } catch (Exception $exc) {

                        }
                        
                    } catch (Exception $ex) {
                        $rep = array("type"=>"echec",'msg1' => "Echec de suppression");
                        echo $ex->getMessage();
                    }
                }
            } catch (Exception $ex) {
                $rep = array("type"=>"echec",'msg1' => "Echec de suppression");
                echo $ex->getMessage();
            }
        } else {
            $rep = array("type"=>"echec",'msg1' => "Aucun élément à supprimer");
        }
        echo json_encode($rep);
        exit();
    }

    public function checkvalidationAction()
    {
        $utilisateurDao = new UtilisateurDAO();
        //$crypt = new Fonction();
        
        if ( !empty($_POST)){
            $password = $_POST["password"];
            $login = $_POST["login"];
            
            $pwdCrypte = sha1(md5($password));
            
            
                $user = $utilisateurDao->obtenirUserPwdValidation($login, $pwdCrypte);
                if ( !empty($user)){
                    echo json_encode(array("type" => "success"));
                }else{
                    echo json_encode(array("type" => "error"));
                }
            
            exit();
        }
        exit();
    }

    public function motdepasseAction()
    {
        if ( !empty($_POST)){
            if ( empty($_POST["ancien"]) || empty($_POST["nouveau"])){
                echo json_encode(array("type" => "error" , "message" => "Paramètres manquants"));
                exit();
            }
            $idUtilisateur = (int)$_SESSION["idUtilisateur"];
            $utilisateurDao = new UtilisateurDAO();
            $utilisateur = $utilisateurDao->getUtilisateurById($idUtilisateur);
            $ancienMotDePasse = sha1(md5($_POST["ancien"]));
            $nouveauMotDePasse = sha1(md5($_POST["nouveau"]));
            if ( $utilisateur->getPassword() != $ancienMotDePasse ){
                echo json_encode(array("type" => "error" , "message" => " Veuillez renseigner votre mot de passe courant" ));
                exit();
            }
            $utilisateur->setPassword($nouveauMotDePasse);
            $utilisateurDao->modifier($utilisateur);
            echo json_encode(array("statut"=>1,"type" => "success"));
            exit();
        }
    }
     public function findAction()
    {
         
        try{
           $nom = trim($_POST["nom"]) ;
          $personneDao = new PersonneDAO();
           $liste= $personneDao->chercherClient($nom);
           $resultat = array();
           foreach ( $liste as $personne ){
               $resultat[]=["id"=>$personne->getIdpersonne(),"value"=>$personne->getNom()." ".$personne->getPrenom()];
              
           }
           echo json_encode(array('data'=>$resultat,'nb'=>count($resultat)));
        } catch (Exception $ex) {
           echo json_encode(array("type" => "error"));
        }
        
        exit();
        
        
    }

}



