<?php

include APPLICATION_PATH . '/DAO/UtilisateurDAO.php';
include APPLICATION_PATH . '/DAO/AuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/EmplacementDAO.php';
include APPLICATION_PATH . '/DAO/RoleDAO.php';
include APPLICATION_PATH . '/DAO/RoleAuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/LogDAO.php';
include PUBLIC_PATH.'/Fonctions/Fonction.php';

class EmplacementController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        session_start();
        if ( isset($_SESSION["codeUser"])){
             $_SESSION["derniereAction"] = new \DateTime();
             $utilisateurDao = new UtilisateurDAO();
             $roleAuthDao = new RoleAuthorisationDAO();
            $user = $utilisateurDao->getUtilisateurByCode($_SESSION["codeUser"]);
            if(is_object($user)){
                if(!$roleAuthDao->existController($user->getRole(), "Emplacement")){
                    $this->_helper->redirector('index' , 'Index');
                }
            }else{
                $this->_helper->redirector('index' , 'Index');
            }
        }else{
            $this->_helper->redirector('index' , 'Index');
        }
    }

    public function indexAction()
    {
         
    }
     public function datatableAction()
    {
       $table = 'emplacement';

        $primaryKey = 'id';
        $columns = array(
            array('db' => 'id', 'dt' => 0),
            array('db' => 'nom', 'dt' => 1)
        );

        $sql_details = array(
            'user' => DB_USER,
            'pass' => DB_PASSWORD,
            'db' => DB_NAME,
            'host' => HOSTNAME
        );

         
        require(PUBLIC_PATH . '/files_to_include/ssp.class.php');

        $resultatDataTable = SSP::simple($_POST, $sql_details, $table, $primaryKey, $columns);
        
       
        //var_dump($resultatDataTable);
        echo utf8_encode(json_encode($resultatDataTable));
        exit();
    }
    
   
    public function enregistrerAction()
    {
       
        if (!empty($_POST)) {
           $empDao = new EmplacementDAO();
           if($empDao->existEmplacementName($_POST['nom'])){
               echo json_encode([ 'data' => NULL, 'message' => 'The element '.$_POST['nom'].' already exists','status' =>200]) ;
                exit();
           }
           $emp  = new Application\Models\Emplacement();
           $emp->setNom($_POST['nom']);
           $emp->setState(1);
           $empDao->save($emp);
           echo json_encode([ 'data' => NULL, 'message' => 'Saved successfully','status' =>200]) ;
        } 
        exit();

    }
    public function editerAction()
    {
       
        
    }
    
    public function deleteAction()
    {
        
    }
    
      public function findAction()
    {
        
        try{
           $nom = trim($_POST["emplacement"]) ;
          $empDao = new EmplacementDAO();
           $liste= $empDao->findByName($nom);
           $resultat = array();
           foreach ( $liste as $emp){
               $resultat[]=["id"=>$emp->getId(),"value"=>$emp->getNom()];
              
           }
           echo json_encode(array('data'=>$resultat,'nb'=>count($resultat)));
        } catch (Exception $ex) {
           echo json_encode(array("type" => "error"));
        }
        
        exit();
        
        
    }
    
}

