<?php

include APPLICATION_PATH . '/DAO/UtilisateurDAO.php';
include APPLICATION_PATH . '/DAO/AuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/ConsommableDAO.php';
include APPLICATION_PATH . '/DAO/EmplacementDAO.php';
include APPLICATION_PATH . '/DAO/RoleDAO.php';
include APPLICATION_PATH . '/DAO/RoleAuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/LogDAO.php';
include PUBLIC_PATH.'/Fonctions/Fonction.php';

class StockController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        session_start();
        if ( isset($_SESSION["codeUser"])){
             $_SESSION["derniereAction"] = new \DateTime();
             $utilisateurDao = new UtilisateurDAO();
             $roleAuthDao = new RoleAuthorisationDAO();
            $user = $utilisateurDao->getUtilisateurByCode($_SESSION["codeUser"]);
            if(is_object($user)){
                if(!$roleAuthDao->existController($user->getRole(), "Stock")){
                    $this->_helper->redirector('index' , 'Index');
                }
            }else{
                $this->_helper->redirector('index' , 'Index');
            }
        }else{
            $this->_helper->redirector('index' , 'Index');
        }
    }

    public function indexAction()
    {
         
    }
     public function datatableAction()
    {
       $table = 'stocks';
        $userDao = new UtilisateurDAO();
        $connexion = $userDao->_em->getConnection();
        $sql = "drop table if exists stocks; CREATE  TABLE IF NOT EXISTS stocks(id INT AUTO_INCREMENT PRIMARY KEY) select st.consommable,et.entree-st.sortie as quantite,COALESCE(st.nomemp,et.nomemp,'PAS DE MOUVEMENT') as emplacement

from (SELECT c.id as id,c.libelle as consommable, sum(IFNULL(s.quantite,0)) as sortie, em.nom as nomemp  FROM consommable c 
left join sortieconsommable s on c.id=s.consommable left join sortie se on se.id=s.sortie left join emplacement em on em.id=se.emplacement WHERE c.state= 1 group by c.id, c.libelle,em.id,em.nom) st join (SELECT c.id as id,c.libelle as consommable, sum(IFNULL(e.quantite,0)) as entree,em.nom as nomemp  FROM consommable c 
left join entreeconsommable e on c.id=e.consommable left join fourniture fe on fe.id=e.fourniture left join emplacement em on em.id=fe.emplacement WHERE c.state= 1 group by c.id, c.libelle,em.id,em.nom) et on st.id = et.id   order by quantite desc";
        $requete = $connexion->prepare($sql);
        $requete->execute();

        $primaryKey = 'id';
        $columns = array(
            array('db' => 'id', 'dt' => 0),
            array('db' => 'consommable', 'dt' => 1),
            array('db' => 'quantite' , 'dt' => 2),
            array('db' => 'emplacement' , 'dt' => 3)
        );

        $sql_details = array(
            'user' => DB_USER,
            'pass' => DB_PASSWORD,
            'db' => DB_NAME,
            'host' => HOSTNAME
        );

         
        require(PUBLIC_PATH . '/files_to_include/ssp.class.php');

        $resultatDataTable = SSP::simple($_POST, $sql_details, $table, $primaryKey, $columns);
        
       
        //var_dump($resultatDataTable);
        echo utf8_encode(json_encode($resultatDataTable));
        exit();
    }
    
  
    
}

